/* Opale page manager */
var tplMgr = {
	fCbkPath : "des:.cbkClosed",
	fWaiMnuPath : "ide:accessibility",
	fWaiBtnPath : "des:.waiBtn",

	init : function(){
		// Close collapsable blocks that are closed by default.
		var vCbks = scPaLib.findNodes(this.fCbkPath);
		for (var i in vCbks) {
			var vTgl = scPaLib.findNode("des:a", vCbks[i]);
			if (vTgl) vTgl.onclick();
		}
		// Accessibility menu focus.
		var vWaiMnu = scPaLib.findNode(this.fWaiMnuPath);
		if (vWaiMnu){
			vWaiMnu.fClass = vWaiMnu.className;
			var vWaiBtns = scPaLib.findNodes(this.fWaiBtnPath,vWaiMnu);
			for (var i in vWaiBtns) {
				vWaiBtns[i].onfocus = function(){vWaiMnu.className = vWaiMnu.fClass + " waiFocus"}
				vWaiBtns[i].onblur = function(){vWaiMnu.className = vWaiMnu.fClass}
			}
		}
		// Set tooltip callback functions.
		if ("scTooltipMgr" in window ) {
			scTooltipMgr.addShowListener(this.sTtShow);
			scTooltipMgr.addHideListener(this.sTtHide);
		}
		// Set SubWin callback functions.
		if ("scDynUiMgr" in window ) {
			scDynUiMgr.subWindow.addOnLoadListener(this.sSwLoad);
			scDynUiMgr.subWindow.addCloseListener(this.sSwClose);
		}
	},
	/** Tooltip lib show callback */
	sTtShow: function(pNode) {
		var vClsBtn = scPaLib.findNode("des:a.tooltip_x", scTooltipMgr.fCurrTt);
		if (vClsBtn) window.setTimeout(function(){vClsBtn.focus();}, pNode.fOpt.DELAY + 10);
		else if (!pNode.onblur) pNode.onblur = function(){scTooltipMgr.hideTooltip(true);};
	},
	/** Tooltip lib hide callback : this = scTooltipMgr */
	sTtHide: function(pNode) {
		if (pNode) pNode.focus();
	},
	/** SubWin lib load callback */
	sSwLoad: function(pFra) {
		var vCo = scPaLib.findNode("ide:content", pFra.contentDocument);
		if (vCo) vCo.focus();
	},
	/** SubWin lib close callback */
	sSwClose: function(pId) {
		var vSubWin = scDynUiMgr.subWindow.fSubWins[pId];
		if (vSubWin && vSubWin.fAnc) vSubWin.fAnc.focus();
	}
}

