var mcgSurMgr = {
	fEnabled : true,
	fImgPath : "des:img.mapImg",
	fIcoPath : "des:img.mapIco",
	fImgEmptyPath : "des:img.mapEmpty",
	fDivEmptyPath : "des:div.mapEmpty",
	fMapPath : "des:map",
	fAreaPath : "chi:area",

	/** mcgSurMgr.init */
	init : function(pFra) {
		scCoLib.util.log("mcgSurMgr.init");
		try{
			this.fIsIE6 = scCoLib.isIE && parseFloat(navigator.appVersion.split("MSIE")[1]) < 7;
			// Init base fields
			pFra.fIco = scPaLib.findNode(this.fIcoPath,this.fFra);
			pFra.fImg = scPaLib.findNode(this.fImgPath,this.fFra);
			// Init mapFra
			pFra.style.position="relative";
			pFra.style.width=pFra.fImg.width+"px";
			pFra.style.height=pFra.fImg.height+"px";
			var vMap = scPaLib.findNode(this.fMapPath,this.fFra);
			pFra.fAreas = scPaLib.findNodes(this.fAreaPath,vMap);
			// Init map image
			pFra.fImgMap = scPaLib.findNode(this.fImgEmptyPath,this.fFraRep);
			pFra.fImgMapHL = $(pFra.fImgMap);
			if (pFra.fImgMapHL && pFra.fImgMapHL.maphilight) {
				pFra.fImgMapHL.maphilight({fade: false});
				pFra.fDivMapHL = scPaLib.findNode(this.fDivEmptyPath,this.fFraRep);
				pFra.fDivMapHL.style.position="absolute";
				pFra.fDivMapHL.style.top="0px";
				pFra.fDivMapHL.style.left="0px";
				pFra.fDivMapHL.style.marginLeft="";
				this.xMapHightlight(pFra,false);
			} else {
				pFra.fImgMap.style.position="absolute";
				pFra.fImgMap.style.top="0px";
				pFra.fImgMap.style.left="0px";
			}
			pFra.fImgMap.style.border="0px";
			pFra.fImgMap.style.cursor="pointer";
//			pFra.fImgMap.width = pFra.fImg.width;
//			pFra.fImgMap.height = pFra.fImg.height;
			// Init map areas
			for (var i=0; i < pFra.fAreas.length; i++){
				this.xInitArea(pFra.fAreas[i],pFra);
			}
			// Init marker icon
			if (this.fIsIE6) {
				pFra.fMkr = document.createElement("span");
				pFra.fMkr.style.position="absolute";
				pFra.fMkr.style.width = pFra.fIco.width+"px";
				pFra.fMkr.style.width = pFra.fIco.height+"px";
				pFra.fMkr.fSrc = pFra.fIco.src;
				pFra.fMkr.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+pFra.fMkr.fSrc+"', sizingMethod='image')";
			} else {
				pFra.fMkr = new Image();
				pFra.fMkr.style.position="absolute";
				pFra.fMkr.src = pFra.fIco.src;
				pFra.fMkr.width = pFra.fIco.width;
				pFra.fMkr.height = pFra.fIco.height;
			}
			pFra.fMkr.fWidth = pFra.fIco.width;
			pFra.fMkr.fHeight = pFra.fIco.height;
			pFra.fMkr.style.visibility = "hidden";
			pFra.insertBefore(pFra.fMkr,pFra.fImg.nextSibling);
		} catch(e){scCoLib.util.log("mcgSurMgr.init ERROR : "+e);alert(e)}
	},

	/** mcgSurMgr.xMapHightlight */
	xMapHightlight : function(pFra,pOn) {
		if (pFra.fImgMapHL) {
			for (var i=0; i < pFra.fAreas.length; i++){
				var vArea = $(pFra.fAreas[i]);
				var vData = vArea.data('maphilight') || {};
				vData.neverOn = !pOn;
				vData.alwaysOn = pOn;
				vArea.data('maphilight', vData).trigger('alwaysOn.maphilight');
			}
		}
	},

	/** mcgSurMgr.setMarker */
	setMarker : function(pFra,pX,pY) {
		scCoLib.util.log("mcgSurMgr.setMarker");
		if (!this.fEnabled) return;
		pFra.fMkr.style.top = (pY-pFra.fMkr.fHeight/2)+"px";
		pFra.fMkr.style.left = (pX-pFra.fMkr.fWidth/2)+"px";
		pFra.fMkr.style.visibility = "";
	},

	/** mcgSurMgr.displayMap */
	displayMap : function(pFra) {
		scCoLib.util.log("mcgSurMgr.displayMap");
		if (!this.fEnabled) return;
		this.xMapHightlight(pFra,true);
	},

	/** mcgSurMgr.hideMap */
	hideMap : function(pFra) {
		scCoLib.util.log("mcgSurMgr.hideMap");
		if (!this.fEnabled) return;
		this.xMapHightlight(pFra,false);
	},

	/** mcgSurMgr.resetMarker */
	resetMarker : function(pFra) {
		scCoLib.util.log("mcgSurMgr.resetMarker");
		if (!this.fEnabled) return;
		pFra.fMkr.style.top = "0px";
		pFra.fMkr.style.left = "0px";
		pFra.fMkr.style.visibility = "hidden";
	},

	/** mcgSurMgr.enable */
	enable : function(pEnable) {
		this.fEnabled = pEnable;
	},

	/** mcgSurMgr.xInitArea */
	xInitArea : function(pArea,pFra) {
		pArea.fFra = pFra;
	}

}


